import { cn } from "@/lib/utils";
import Image from "next/image";

export function Logo({ className }: { className?: string }) {
  return (
    <div className={cn("flex items-center gap-2 font-bold text-lg font-headline", className)}>
      <Image src="/logo.png" alt="RiteClick Technology Logo" width={40} height={40} />
      <span className="hidden sm:inline-block text-foreground">RiteClick Technology</span>
    </div>
  );
}
