import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "@/components/ui/accordion";

const faqs = [
    {
        question: "How long is the training?",
        answer: "The training runs for 3 months with live virtual classes on Telegram. You’ll also get recorded sessions in case you miss a class."
    },
    {
        question: "How much does the training cost?",
        answer: "The fee is ₦200,000 for the full 3-month training, which covers live sessions, mentorship, access to resources, and a certificate of completion."
    },
    {
        question: "Who is this training for?",
        answer: "Our training is designed for beginners and professionals who want to start or grow their careers in Cloud Computing, Data Science/AI, Data Analysis, or Cyber Security. No prior tech experience is required."
    },
    {
        question: "What tools or software do I need?",
        answer: "You only need a laptop and stable internet connection. We will guide you in setting up all the tools you’ll use during the training."
    },
    {
        question: "How are classes delivered?",
        answer: "Classes are delivered live on Telegram via streaming, with opportunities for Q&A. You’ll also have access to a dedicated WhatsApp group for your course."
    },
    {
        question: "Will I get hands-on experience?",
        answer: "Yes! You’ll work on real projects and portfolio-ready assignments that showcase your skills to potential employers."
    },
    {
        question: "Do I get a certificate after the training?",
        answer: "Yes. You’ll receive a Certificate of Completion from RiteClick Technology after successfully completing the course."
    },
    {
        question: "What career support do you provide?",
        answer: "We don’t just teach. We help with: LinkedIn optimization, Portfolio building, Guidance on finding remote jobs, Career mentorship."
    },
    {
        question: "Can I pay in installments?",
        answer: "Yes. We offer flexible payment plans — you can pay in two before the end of the training."
    },
    {
        question: "How do I register?",
        answer: "Simply click Pay for Course to secure your spot or Join WhatsApp Group to connect with our team and get more details before enrolling."
    }
]

export function CourseFaq() {
  return (
    <Accordion type="single" collapsible className="w-full">
      {faqs.map((item, index) => (
        <AccordionItem value={`item-${index}`} key={index}>
          <AccordionTrigger className="text-left font-semibold">{item.question}</AccordionTrigger>
          <AccordionContent className="text-muted-foreground">
            {item.answer}
          </AccordionContent>
        </AccordionItem>
      ))}
    </Accordion>
  );
}
