
import { Button } from '@/components/ui/button';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Check, Megaphone, Search, Users, FileText, MessageCircle, Link as LinkIcon } from 'lucide-react';
import Image from 'next/image';
import type { Metadata } from 'next';
import Link from 'next/link';

export const metadata: Metadata = {
    title: 'Digital Marketing Consultancy | RiteClick Technology',
    description: 'Comprehensive digital marketing services to grow your brand online. We specialize in paid ads (Google, Facebook, TikTok), SEO, social media management, and content strategy.',
};

const services = [
  {
    title: 'Paid Advertising (PPC)',
    description: 'Reach your target audience with precision-targeted ad campaigns on major platforms. We manage your budget to maximize ROI and drive conversions.',
    icon: Megaphone,
    features: ['Google & YouTube Ads', 'Facebook & Instagram Ads', 'TikTok Ads', 'LinkedIn Ads'],
  },
  {
    title: 'Search Engine Optimization (SEO)',
    description: 'Improve your organic search rankings to attract high-quality traffic. We use proven strategies to get you on the front page of Google.',
    icon: Search,
    features: ['Keyword Research & Strategy', 'On-Page & Technical SEO', 'Link Building', 'Local SEO'],
  },
  {
    title: 'Social Media Management',
    description: 'Build a strong, engaged community around your brand. We manage your social profiles, create compelling content, and interact with your followers.',
    icon: Users,
    features: ['Content Calendar Creation', 'Community Engagement', 'Follower Growth Strategy', 'Performance Reporting'],
  },
  {
    title: 'Content Marketing & Strategy',
    description: 'Attract and retain customers with valuable, relevant content. We develop a content strategy that establishes you as a thought leader in your industry.',
    icon: FileText,
    features: ['Blog Post & Article Writing', 'Email Marketing Campaigns', 'Lead Magnet Creation', 'Content Distribution'],
  },
];

export default function DigitalMarketingConsultancyPage() {
  return (
    <div className="flex flex-col min-h-screen">
      {/* Hero Section */}
      <section className="relative w-full py-20 md:py-32 lg:py-40 flex items-center justify-center text-center text-white">
        <Image
          src="/digitalmarketing.png"
          alt="Digital Marketing Consultancy"
          fill
          priority
          className="object-cover -z-10 brightness-50"
        />
        <div className="container px-4 md:px-6">
          <div className="flex flex-col items-center space-y-4">
            <h1 className="text-4xl font-bold tracking-tighter sm:text-5xl xl:text-6xl/none font-headline">
              Digital Marketing Consultancy
            </h1>
            <p className="max-w-[700px] text-lg md:text-xl">
              Grow your brand and accelerate your growth with data-driven digital marketing strategies that deliver results.
            </p>
          </div>
        </div>
      </section>

      {/* Services Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-secondary">
        <div className="container px-4 md:px-6">
          <div className="text-center">
            <h2 className="text-3xl font-bold tracking-tighter sm:text-5xl font-headline">Our Digital Marketing Services</h2>
            <p className="max-w-[900px] mx-auto text-muted-foreground md:text-xl/relaxed mt-4">
              We offer a complete suite of digital marketing services to increase your online visibility and drive revenue.
            </p>
          </div>
          <div className="mx-auto grid grid-cols-1 gap-8 py-12 sm:grid-cols-2">
            {services.map((service, index) => {
              const Icon = service.icon;
              return (
                <Card key={index} className="flex flex-col transition-transform transform hover:-translate-y-2">
                  <CardHeader>
                    <div className="flex items-center gap-4">
                      <div className="bg-primary/10 rounded-full p-3 w-fit">
                        <Icon className="h-8 w-8 text-primary" />
                      </div>
                      <CardTitle className="font-headline text-2xl">{service.title}</CardTitle>
                    </div>
                  </CardHeader>
                  <CardContent className="flex-grow flex flex-col">
                    <p className="text-muted-foreground mb-6">{service.description}</p>
                    <ul className="space-y-3 flex-grow">
                      {service.features.map((feature, fIndex) => (
                         <li key={fIndex} className="flex items-start gap-3">
                            <Check className="h-5 w-5 text-primary mt-1 flex-shrink-0" />
                            <span className="text-muted-foreground">{feature}</span>
                        </li>
                      ))}
                    </ul>
                  </CardContent>
                </Card>
              );
            })}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="w-full py-12 md:py-24 lg:py-32 bg-background">
        <div className="container text-center">
            <h2 className="text-3xl md:text-4xl font-bold font-headline">Ready to Boost Your Online Presence?</h2>
            <p className="mt-4 max-w-2xl mx-auto text-muted-foreground">
              Contact us today for a free consultation and let's discuss how we can help you achieve your marketing goals.
            </p>
            <div className="mt-8 flex flex-col sm:flex-row items-center justify-center gap-4">
                <Button size="lg" asChild>
                  <Link href="https://calendly.com/riteclick/new-meeting" target="_blank" rel="noopener noreferrer">
                    Schedule a Free Consultation <LinkIcon className="ml-2" />
                  </Link>
                </Button>
                <Button size="lg" variant="outline" asChild>
                    <a href="https://wa.me/2349115572489" target="_blank" rel="noopener noreferrer">
                        <MessageCircle className="mr-2" /> Chat on WhatsApp
                    </a>
                </Button>
            </div>
        </div>
      </section>
    </div>
  );
}
